﻿uses MathExtensions;

// условие задачи:
function Uslovie(c, d: int): bool; 
begin
   var c1 := d;
   var d1 := c div 2;
   Result := 100 * d + c = 2 * (100 * d1 + c1); 
end;


// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin
   // решаем задачу -->
   // c - центы
   // d - доллары     
    foreach var d in Range(0, 99) do   
       foreach var c in Range(0, 98, 2) do 
          if Uslovie(c, d) then begin
              // печатаем ответ:
              Writeln($' Долларов было:  {d}  | Центов было:  {c}');
              Writeln($' Долларов стало: {c / 2}  | Центов стало: {d}');    
           end;
    Writeln;              
end; 


procedure Solve2();
begin           
   var res := 
     Range(0, 99)                    // Доллары d
     .SelectMany(d -> 
        Range(0, 98, 2)              // Центы c (чётные)
        .Where(c -> Uslovie(c, d))   // Фильтруем по условию
        .Select(c -> (c, d))         // Создаём пару (центы, доллары)
     );
   // печатаем ответ:
   foreach var (c, d) in res do begin
      Writeln($' Долларов было:  {d}  | Центов было:  {c}');
      Writeln($' Долларов стало: {c / 2}  | Центов стало: {d}'); 
      Writeln;      
   end;
end; 


procedure Solve3();
begin           
  var dollars := Range(0, 99);                 // Доллары: 0..99
  var cents := Range(0, 98, 2);                // Центы: 0,2,4,...,98 (чётные)
  var solutions := Cartesian(dollars, cents)   // Все пары (d, c)
                  .Where(dc -> Uslovie(dc.Item2, dc.Item1))  // pair = (dollar, cent)
                  .Select(dc -> (dc.Item1, dc.Item2));
   // печатаем ответ:
   if solutions.Any() then begin
      Writeln(' Найдено решений: {solutions.Count()}');
      foreach var (c, d) in solutions do begin
         Writeln($' Долларов было:  {d}  | Центов было:  {c}');
         Writeln($' Долларов стало: {c div 2}  | Центов стало: {d}'); 
         Writeln;      
      end;
   end;
end;


procedure Solve4();
begin    
   var dollars := Range(0, 99);   
   var cents := Range(0, 98, 2);
   var solutions := Cartesian(dollars, cents)
                   .Where(\(d, c) -> Uslovie(c, d))  // Распаковываем кортеж
                   .Select(\(d, c) -> (d, c));       // Возвращаем кортеж
   // печатаем ответ:                   
  foreach var (d, c) in solutions do begin
     Writeln($' Долларов было:  {d}  | Центов было:  {c}');
     Writeln($' Долларов стало: {c div 2}  | Центов стало: {d}'); 
     Writeln;      
   end;
end;


procedure Solve5();
begin   
   for var d := 0 to 99 do
      for var c := 0 to 99 do
      begin
         var c1 := d;
         var d1 := c div 2;
         
         if (100 * d + c = 2 * (100 * d1 + c1)) then begin
             Writeln($' Долларов было:  {d}  | Центов было:  {c}');
             Writeln($' Долларов стало: {d1}  | Центов стало: {c1}'); 
             Writeln;
         end
      end;
   Writeln;
end;
 
     
begin
   Writeln(' Чисто американская задача');
   Writeln(' Математический фольклор. Задача Д45');   
   Writeln; 
   Solve();   
   Solve2(); 
   Solve3();   
   Solve4();  
   Solve5();     
end.
